(*| 14:20 16/07/1992 *)
UNIT GXFiles;

INTERFACE

PROCEDURE File_Directory;

PROCEDURE Load_DAC_Data;

PROCEDURE Save_DAC_Data;

PROCEDURE Load_RAW_Data;

PROCEDURE Save_RAW_Data;

PROCEDURE Load_PCX_Data;

PROCEDURE Save_PCX_Data;

PROCEDURE Load_GIF_Data;

PROCEDURE Load_VGAP_Data;

PROCEDURE Save_VGAP_Data;

PROCEDURE Load_EXE_Data;

PROCEDURE Save_EXE_Data;

PROCEDURE Load_BMP_Data;

PROCEDURE Save_BMP_Data;

IMPLEMENTATION

USES Crt,Dos,GXCommon;

TYPE
  String4 = STRING[4];
  THdrClass = (Bytes,Rec);
  TPCXHdr = RECORD
              CASE THdrClass OF
                Bytes : (HdrBytes   : ARRAY[0..$7F] OF BYTE);
                Rec   : (PCXmanuf   : BYTE;
                         PCXversion : BYTE;
                         PCXencoding: BYTE;
                         PCXbitpixel: BYTE;
                         PCXx1      : WORD;
                         PCXy1      : WORD;
                         PCXx2      : WORD;
                         PCXy2      : WORD;
                         PCXHres    : WORD;
                         PCXVres    : WORD;
                         PCXpalette : ARRAY[0..15,0..2] OF BYTE;
                         PCXvmode   : BYTE;
                         PCXplanes  : BYTE;
                         PCXlinebyte: WORD;
                        );
            END;
  TBMPHdr = RECORD
              CASE THdrClass OF
                Bytes : (HdrBytes   : ARRAY[0..$35] OF BYTE);
                Rec   : (BMPtype    : WORD;
                         BMPfsize   : LongInt;
                         BMPres1    : WORD;
                         BMPres2    : WORD;
                         BMPoffset  : LongInt;
                         BMPbsize   : LongInt;
                         BMPwidth   : LongInt;
                         BMPheight  : LongInt;
                         BMPplanes  : WORD;
                         BMPbitpixel: WORD;
                         BMPencoding: LongInt;
                         BMPimagesiz: LongInt;
                         BMPxpelspm : LongInt;
                         BMPypelspm : LongInt;
                         BMPclrused : LongInt;
                         BMPclrimp  : LongInt;
                        );
            END;
  TGIFHdr = RECORD
              CASE THdrClass OF
                Bytes : (HdrBytes   : ARRAY[0..$0C] OF BYTE);
                Rec   : (GIFsignatur: ARRAY[1..6] OF CHAR;
                         GIFwidth   : WORD;
                         GIFheight  : WORD;
                         GIFflags   : BYTE;
                         GIFbackgrnd: BYTE;
                         GIFaspect  : BYTE;
                        );
            END;

VAR
  S1,S2,D1,D2: FILE;

FUNCTION FileSizeOK(Size,Min,Max: LongInt): BOOLEAN;
BEGIN
  FileSizeOK := (Size >= Min) AND (Size <= Max);
END;  { FileSizeOK }

PROCEDURE BadSize;
BEGIN
  Writeln('File size incorrect, load aborted.');
END;

PROCEDURE File_Directory;
VAR
  SR: SearchRec;
  C: CHAR;
BEGIN
  ClrScr;
  Writeln('Binary files :');
  FindFirst('*.DAC',AnyFile,SR);
  WHILE DOsError = 0 DO BEGIN
    Write(SR.Name:16);
    FindNext(SR);
  END;
  Writeln;
  Writeln('PCX files :');
  FindFirst('*.PCX',AnyFile,SR);
  WHILE DOsError = 0 DO BEGIN
    Write(SR.Name:16);
    FindNext(SR);
  END;
  Writeln;
  Writeln('GIF files :');
  FindFirst('*.GIF',AnyFile,SR);
  WHILE DOsError = 0 DO BEGIN
    Write(SR.Name:16);
    FindNext(SR);
  END;
  Writeln;
  Writeln('VGAPaint files :');
  FindFirst('*.PIC',AnyFile,SR);
  WHILE DOsError = 0 DO BEGIN
    Write(SR.Name:16);
    FindNext(SR);
  END;
  Writeln;
  Writeln('EXE files :');
  FindFirst('*.EXE',AnyFile,SR);
  WHILE DOsError = 0 DO WITH SR DO BEGIN
    IF FileSizeOK(Size,$10650-1,$10650+1) THEN
      Write(Name:16);
    FindNext(SR);
  END;
  Writeln;
  Writeln('BMP files :');
  FindFirst('*.BMP',AnyFile,SR);
  WHILE DOsError = 0 DO BEGIN
    Write(SR.Name:16);
    FindNext(SR);
  END;
  Writeln;
  Writeln('RAW files :');
  FindFirst('*.RAW',AnyFile,SR);
  WHILE DOsError = 0 DO WITH SR DO BEGIN
    IF FileSizeOK(Size,64800-1,64800+1) THEN
      Write(Name:16);
    FindNext(SR);
  END;
  Writeln;
  C := ReadKey;
END;  { File_Directory }

FUNCTION OpenOK(SourceNum: Integer; FileExt: String4): BOOLEAN;
VAR
  C: CHAR;
BEGIN
  IF SourceNum = 2 THEN BEGIN
    Assign(S2,FileName + FileExt);
{$I-}
    Reset(S2,1);
{$I+}
  END ELSE BEGIN
    Assign(S1,FileName + FileExt);
{$I-}
    Reset(S1,1);
{$I+}
  END;
  IF IOResult = 0 THEN
    OpenOK:= TRUE
  ELSE BEGIN
    Writeln;
    Writeln('Unable to open file ',FileName,FileExt);
    Writeln('Load aborted. Press any key to continue');
    C:= ReadKey;
    OpenOK := FALSE;
  END;
END;  { OpenOK }

PROCEDURE ReadPal;
VAR
  NumRead: WORD;
  FSize: LongInt;
  SPSeg,SPOfs,DPSeg,DPOfs: WORD;
BEGIN
  IF OpenOK(2,'.PAL') THEN BEGIN
    FSize := FileSize(S2);
    IF FileSizeOK(FSize,$300,$300) THEN
      BlockRead(S2,DacBuffer,$300,NumRead)
    ELSE IF NOT FileSizeOK(FSize,$407,$407) THEN
      BadSize
    ELSE BEGIN
      BlockRead(S2,MiscBuffer1^,7,NumRead);
      BlockRead(S2,MiscBuffer1^,$400,NumRead);
      SPSeg := Seg(MiscBuffer1^);
      SPOfs := Ofs(MiscBuffer1^);
      DPSeg := Seg(DacBuffer);
      DPOfs := Ofs(DacBuffer);
      ASM
        PUSH DS
        MOV  AX,SPSeg
        MOV  DS,AX
        MOV  SI,SPOfs
        MOV  AX,DPSeg
        MOV  ES,AX
        MOV  DI,DPOfs
        MOV  CX,$100
@1:
        MOVSB
        MOVSB
        MOVSB
        LODSB
        LOOP @1
        POP  DS
      END;
    END;
    Close(S2);
  END;

END;  { ReadPal }

PROCEDURE ReadFFPal(SrcPointer: Pointer; SrcOfs,PalSize: WORD);
VAR
  SPOfs,SPSeg,DPOfs,DPSeg: WORD;
BEGIN
  SPOfs := Ofs(SrcPointer^) + SrcOfs;
  SPSeg := Seg(SrcPointer^);
  DPOfs := Ofs(DacBuffer);
  DPSeg := Seg(DacBuffer);
  ASM
    PUSH DS
    MOV  AX,DPSeg
    MOV  ES,AX
    MOV  AX,SPSeg
    MOV  DS,AX
    MOV  SI,SPOfs
    MOV  DI,DPOfs
    MOV  CX,PalSize
@1:
    LODSB
    SHR  AL,1
    SHR  AL,1
    STOSB
    LOOP @1
    POP  DS
  END;
END;  { ReadFFPal }

PROCEDURE WriteFFPal(DestPointer: Pointer; DestOfs,PalSize: WORD);
VAR
  SPOfs,SPSeg,DPOfs,DPSeg: WORD;
BEGIN
  DPOfs := Ofs(DestPointer^) + DestOfs;
  DPSeg := Seg(DestPointer^);
  SPOfs := Ofs(DacBuffer);
  SPSeg := Seg(DacBuffer);
  ASM
    PUSH DS
    MOV  AX,DPSeg
    MOV  ES,AX
    MOV  AX,SPSeg
    MOV  DS,AX
    MOV  SI,SPOfs
    MOV  DI,DPOfs
    MOV  CX,PalSize
@1:
    LODSB
    SHL  AL,1
    SHL  AL,1
    STOSB
    LOOP @1
    POP  DS
  END;
END;  { WriteFFPal }

PROCEDURE Load_DAC_Data;

  PROCEDURE ReadData;
  VAR
    NumRead: WORD;
  BEGIN
    BlockRead(S1,DacBuffer,$300,NumRead);
    BlockRead(S1,VBuf1^,$8000,NumRead);
    BlockRead(S1,VBuf2^,$8000,NumRead);
  END;

BEGIN
  IF OpenOK(1,'.DAC') THEN BEGIN
    IF FileSizeOK(FileSize(S1),$10300-1,$10300+1) THEN
      ReadData
    ELSE
      BadSize;
    Close(S1);
  END;
END;  { Load_DAC_Data }

PROCEDURE Save_DAC_Data;

  PROCEDURE OpenFiles;
  BEGIN
    Assign(D1,FileName+'.DAC');
    Rewrite(D1,1);
  END;

  PROCEDURE WriteData;
  VAR
    NumWritten: WORD;
  BEGIN
    BlockWrite(D1,DacBuffer,$300,NumWritten);
    BlockWrite(D1,VBuf1^,$8000,NumWritten);
    BlockWrite(D1,VBuf2^,$8000,NumWritten);
  END;

BEGIN
  OpenFiles;
  WriteData;
  Close(D1);
END;  { Save_DAC_Data }

PROCEDURE Load_RAW_Data;

  PROCEDURE ReadData;
  VAR
    NumRead: WORD;
  BEGIN
    BlockRead(S1,MiscBuffer1^,$320,NumRead);
    ReadFFPal(MiscBuffer1,$20,$300);
    BlockRead(S1,VBuf1^,$8000,NumRead);
    BlockRead(S1,VBuf2^,$8000,NumRead);
  END;

BEGIN
  IF OpenOK(1,'.RAW') THEN BEGIN
    IF FileSizeOK(FileSize(S1),64800-1,64800+1) THEN
      ReadData
    ELSE
      BadSize;
    Close(S1);
  END;
END;  { Load_RAW_Data }

PROCEDURE Save_RAW_Data;

  PROCEDURE OpenFiles;
  BEGIN
    Assign(D1,FileName+'.RAW');
    Rewrite(D1,1);
  END;

  PROCEDURE WriteData;
  CONST
    RawHdr:ARRAY[$00..$1F] OF BYTE =
     ($6D,$68,$77,$61,$6E,$68,$00,$04,$01,$40,$00,$C8,$01,$00,$00,$00,
      $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00);
  VAR
    NumWritten: WORD;
  BEGIN
    BlockWrite(D1,RawHdr,$20);
    WriteFFPal(MiscBuffer1,0,$300);
    BlockWrite(D1,MiscBuffer1^,$300);
    BlockWrite(D1,VBuf1^,$8000,NumWritten);
    BlockWrite(D1,VBuf2^,$7A00,NumWritten);
  END;

BEGIN
  OpenFiles;
  WriteData;
  Close(D1);
END;  { Save_RAW_Data }

PROCEDURE Load_PCX_Data;

  PROCEDURE ReadImageData;
  LABEL
    SingleByte,NextByte,LastByte;
  VAR
    NumRead1,NumRead2: WORD;
    SPOfs,SPSeg,DPOfs,DPSeg,Limit: WORD;
    PCXHdr: TPCXHdr;
  BEGIN
    BlockRead(S1,MiscBuffer1^,MiscBufferSize,NumRead1);
    BlockRead(S1,DacBuffer,$300,NumRead2);
    IF NumRead2 > 0 THEN BEGIN
      Writeln('PCX file too large');
      Delay(1000);
      EXIT;
    END;
    MOVE(MiscBuffer1^,PCXHdr.HdrBytes,SizeOf(TPCXHdr));
    WITH PCXHdr DO BEGIN
      CASE PCXbitpixel OF
        1 : CASE PCXplanes OF
              1 : Write('Mono');
              4 : Write('16 Colour');
              ELSE Write(PCXplanes,' planes');
            END;
        8 : Write('256 Colour');
      END;
      Write(' Image ',PCXx2-PCXx1 + 1,'x',PCXy2-PCXy1+1);
      Writeln(' Screen ',PCXHres,'x',PCXVres,' Ver ',PCXVersion);
      IF PCXbitpixel <> 8 THEN BEGIN
        Writeln('Not 256 colour image. Aborting');
        Delay(1000);
        EXIT;
      END;
      IF (PCXversion = 5) AND (MiscBuffer1^[NumRead1-$301] = $0C) THEN BEGIN
        NumRead1:= NumRead1 - $301;
        ReadFFPal(MiscBuffer1,NumRead1+1,$300);
      END;
    END;
    Limit := Ofs(MiscBuffer1^) + NumRead1;
    SPOfs := Ofs(MiscBuffer1^) + $80;
    SPSeg := Seg(MiscBuffer1^);
    DPOfs := Ofs(VBuf1^);
    DPSeg := Seg(VBuf1^) + (DPOfs SHR 4);
    DPOfs := DPOfs AND $000F;
    ASM
      PUSH DS
      MOV  DX,Limit
      MOV  AX,DPSeg
      MOV  ES,AX
      MOV  AX,SPSeg
      MOV  DS,AX
      MOV  SI,SPOfs
      MOV  DI,DPOfs
      SUB  AX,AX
  NextByte:
      CMP  SI,DX
      JAE  LastByte
      LODSB
      CMP  AL,0C0H
      JB   SingleByte
      AND  AL,03FH
      MOV  CX,AX
      LODSB
      REP  STOSB
      JMP  NextByte

  SingleByte:
      STOSB
      JMP  NextByte

  LastByte:
      POP  DS
    END;
    Delay(1000);
  END;

BEGIN
  IF OpenOK(1,'.PCX') THEN BEGIN
    ReadImageData;
    Close(S1);
  END;
END;  { Load_PCX_Data }

PROCEDURE Save_PCX_Data;

  PROCEDURE OpenFiles;
  BEGIN
    Assign(D1,FileName+'.PCX');
    Rewrite(D1,1);
  END;

  PROCEDURE WriteData;
  CONST
    PcxHdr:ARRAY[$00..$7F] OF BYTE =
     ($0A,$05,$01,$08,$00,$00,$00,$00,$3F,$01,$C7,$00,$40,$01,$C8,$00,
      $00,$00,$00,$80,$00,$00,$00,$80,$00,$80,$80,$00,$00,$00,$80,$80,
      $00,$80,$00,$80,$80,$80,$80,$80,$C0,$C0,$C0,$FF,$00,$00,$00,$FF,
      $00,$FF,$FF,$00,$00,$00,$FF,$FF,$00,$FF,$00,$FF,$FF,$FF,$FF,$FF,
      $00,$01,$40,$01,$01,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
      $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
      $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
      $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00);
  VAR
    NumWritten: WORD;
    SPOfs,SPSeg,DPOfs,DPSeg: WORD;
  BEGIN
    BlockWrite(D1,PcxHdr,$80,NumWritten);
    SPOfs := Ofs(VBuf1^);
    SPSeg := Seg(VBuf1^) + (SPOfs SHR 4);
    SPOfs := SPOfs AND $000F;
    DPOfs := Ofs(MiscBuffer1^);
    DPSeg := Seg(MiscBuffer1^);
    ASM
      PUSH DS
      MOV  AX,SPSeg
      MOV  DS,AX
      MOV  AX,DPSeg
      MOV  ES,AX
      MOV  DI,DPOfs
      MOV  SI,SPOfs
      MOV  CX,Screen_Height
      MOV  DX,Screen_Width
@1:
      MOV  BX,DX
      PUSH CX
      SUB  CL,CL
@3:
      LODSB
      DEC  BX
      JZ   @2
      CMP  AL,[SI]
      JNZ  @2
      CMP  CL,$3E
      JZ   @2
      INC  CL
      JMP  @3

@2:
      OR   CL,CL
      JZ   @4
@6:
      INC  CL
      OR   CL,$C0
      MOV  AH,AL
      MOV  AL,CL
      STOSW
@7:
      SUB  CL,CL
      OR   BX,BX
      JNZ  @3
      JMP  @5

@4:
      CMP  AL,$C0
      JAE  @6
      STOSB
      JMP  @7

@5:
      POP  CX
      LOOP @1
      MOV  NumWritten,DI
      POP  DS
    END;
    BlockWrite(D1,MiscBuffer1^,NumWritten);
    MiscBuffer1^[0] := $0C;
    BlockWrite(D1,MiscBuffer1^,1);
    WriteFFPal(MiscBuffer1,0,$300);
    BlockWrite(D1,MiscBuffer1^,$300);

  END;

BEGIN
  OpenFiles;
  WriteData;
  Close(D1);
END;  { Save_PCX_Data }

{$F+}
PROCEDURE Decoder(SrcPtr,DestPtr: Pointer;
     Image_Width,Screen_Width,Screen_Height,Image_Offset: WORD); EXTERNAL;
{$L GIFDECOD}
{$F-}

PROCEDURE Load_GIF_Data;

  PROCEDURE ReadData;
  CONST
    Data_Offset = $317;      {offset to start of image data}
    Colour_Map_Offset = $0D;
  VAR
    NumRead,NumRead2: WORD;
    SPOfs,SPSeg,DPOfs,DPSeg: WORD;
    GIF_Data_Ptr: PMiscBuffer;
    Image_Data_Offset: INTEGER;
    Image_View_Offset,W_Offset,H_Offset: WORD;
    Colour_Map_Size: INTEGER;
    GIFHdr: TGIFHdr;
    Answer: String;
    Result: INTEGER;
  BEGIN
    GIF_Data_Ptr := MiscBuffer1;
    BlockRead(S1,MiscBuffer1^,MiscBufferSize,NumRead);
    BlockRead(S1,MiscBuffer2^,MiscBufferSize,NumRead);
    BlockRead(S1,DacBuffer,$300,NumRead2);
    IF NumRead2 > 0 THEN BEGIN
      Writeln('GIF file too large');
      Delay(1000);
      EXIT;
    END;
    MOVE(GIF_Data_Ptr^,GIFHdr,SizeOf(TGIFHdr));
    Colour_Map_Size := $300;
    WITH GIFHdr DO BEGIN
      Write('Image ',GIFwidth,'x',GIFheight);
      Image_View_Offset := 0;
      W_Offset := 0;
      H_Offset := 0;
      IF GIFwidth > Screen_Width THEN BEGIN
        W_Offset := (GIFwidth - Screen_Width) SHR 1;
        Image_View_Offset := W_Offset;
      END;
      IF GIFheight > Screen_Height THEN BEGIN
        H_Offset :=  ((GIFheight - Screen_Height) SHR 1);
        Image_View_Offset := Image_View_Offset +
                       (H_Offset * GIFwidth);
      END;
      IF Image_View_Offset = 0 THEN
        Write('  ')
      ELSE BEGIN
        Write('.  Cropped - ',Image_View_Offset,
              ', w=',W_Offset,', h=',H_Offset,
              '    New Value, or <RET> : ');
        Readln(Answer);
        IF Length(Answer) > 0 THEN BEGIN
          VAL(Answer,Image_View_Offset,Result);
        END;
      END;
      CASE GIFflags AND $07 OF
        7 : Write('256 colour');
        3 : BEGIN
              Write('16 colour');
              Colour_Map_Size := $30;
            END;
        ELSE BEGIN
          Writeln('Not 256 or 16 colour image. Aborting');
          EXIT;
        END;
      END;
      Image_Data_Offset := Colour_Map_Size + $17;
      Writeln('  Expanding GIF data');
      ReadFFPal(GIF_Data_Ptr, Colour_Map_Offset, Colour_Map_Size);
      GIF_Data_Ptr := IndexPtr(MiscBuffer1, Image_Data_Offset);
      Decoder(GIF_Data_Ptr, VBuf1, GIFwidth, Screen_Width,Screen_Height,
                                                    Image_View_Offset);
    END;
  END;

BEGIN
  IF OpenOK(1,'.GIF') THEN BEGIN
    ReadData;
    Close(S1);
  END;
END;  { Load_GIF_Data }

PROCEDURE Load_VGAP_Data;

  PROCEDURE ReadData;
  VAR
    NumRead: WORD;
  BEGIN
    BlockRead(S1,MiscBuffer1^,11,NumRead);
    BlockRead(S1,VBuf1^,$8000,NumRead);
    BlockRead(S1,VBuf2^,$7A04,NumRead);
  END;

BEGIN
  IF OpenOK(1,'.PIC') THEN BEGIN
    IF FileSizeOK(FileSize(S1),$FA0F-1,$FA0F+1) THEN
      ReadData
    ELSE
      BadSize;
    Close(S1);
    ReadPal;
  END;
END;  { Load_VGAP_Data }

PROCEDURE Save_VGAP_Data;
VAR
  D2: FILE;

  PROCEDURE OpenFiles;
  BEGIN
    Assign(D1,FileName+'.PAL');
    Rewrite(D1,1);
    Assign(D2,FileName+'.PIC');
    Rewrite(D2,1);
  END;

  PROCEDURE ReformatDacData;
  VAR
    ThisData:ARRAY[0..3] OF BYTE;
    I,J,NumWrite: INTEGER;
  BEGIN
    J := 0;
    ThisData[3] := 0;
    FOR I := 1 TO 256 DO BEGIN
      ThisData[0] := DacBuffer[J];
      ThisData[1] := DacBuffer[J+1];
      ThisData[2] := DacBuffer[J+2];
      BlockWrite(D1,ThisData,4,NumWrite);
      J := J+3;
    END;
  END;

  PROCEDURE WriteData;
  CONST
    PicHdr:ARRAY[0..10] OF BYTE = ($FD,$0B,$71,0,0,8,$FA,0,10,$C8,0);
    PalHdr:ARRAY[0..6] OF BYTE = ($FD,$AA,$57,0,0,0,4);
  VAR
    NumWritten: WORD;
  BEGIN
    BlockWrite(D1,PalHdr,7,NumWritten);
    ReformatDacData;
    BlockWrite(D2,PicHdr,11,NumWritten);
    BlockWrite(D2,VBuf1^,$8000,NumWritten);
    BlockWrite(D2,VBuf2^,$7A04,NumWritten);
  END;

BEGIN
  OpenFiles;
  WriteData;
  Close(D1);
  Close(D2);
END;  { Save_VGAP_Data }

PROCEDURE Load_EXE_Data;

  PROCEDURE ReadData;
  VAR
    NumRead: WORD;
  BEGIN
    BlockRead(S1,MiscBuffer1^,$350,NumRead);
    BlockRead(S1,DacBuffer,$300,NumRead);
    BlockRead(S1,VBuf1^,$8000,NumRead);
    BlockRead(S1,VBuf2^,$8000,NumRead);
  END;

BEGIN
  IF OpenOK(1,'.EXE') THEN BEGIN
    IF FileSizeOK(FileSize(S1),$10650-1,$10650+1) THEN
      ReadData
    ELSE
      BadSize;
    Close(S1);
  END;
END;  { Load_EXE_Data }

PROCEDURE Save_EXE_Data;

  PROCEDURE OpenFiles;
  BEGIN
    Assign(S1,'VGAMERGE.HDR');
    Reset(S1,1);
    Assign(D1,FileName+'.EXE');
    Rewrite(D1,1);
  END;

  PROCEDURE WriteData;
  VAR
    NumRead,NumWrite: WORD;
  BEGIN
    BlockRead(S1,MiscBuffer1^,$350,NumRead);
    BlockWrite(D1,MiscBuffer1^,NumRead,NumWrite);
    BlockWrite(D1,DacBuffer,$300,NumWrite);
    BlockWrite(D1,VBuf1^,$8000,NumWrite);
    BlockWrite(D1,VBuf2^,$8000,NumWrite);
  END;

BEGIN
  OpenFiles;
  WriteData;
  Close(S1);
  Close(D1);
END;  { Save_EXE_Data }

PROCEDURE Load_BMP_Data;

  PROCEDURE ReadData;
  VAR
    NumRead: WORD;
    SPOfs,SPSeg,DPOfs,DPSeg,Data_Start,Limit,Count: WORD;
    BMPHdr: TBMPHdr;
  BEGIN
    BlockRead(S1,MiscBuffer1^,MiscBufferSize,NumRead);
    MOVE(MiscBuffer1^,BMPHdr.HdrBytes,SizeOf(TBMPHdr));
    WITH BMPHdr DO BEGIN
      CASE BMPbitpixel OF
        1 : Write('Mono');
        4 : Write('16 colour');
        ELSE Write(BMPplanes,' planes');
      END;
      Writeln(' Image ',BMPwidth,'x',BMPheight);
      IF BMPbitpixel <> 4 THEN BEGIN
        Writeln('Not 16 colour image. Aborting');
        EXIT;
      END;
      Data_Start := Ofs(MiscBuffer1^) + BMPoffset;
      Limit := Ofs(MiscBuffer1^) + NumRead;
      SPOfs := Ofs(MiscBuffer1^) + SizeOf(TBMPHdr);
      SPSeg := Seg(MiscBuffer1^);
      DPOfs := Ofs(DacBuffer);
      DPSeg := Seg(DacBuffer);
      ASM
        PUSH DS
        MOV  CX,16
        MOV  AX,DPSeg
        MOV  ES,AX
        MOV  AX,SPSeg
        MOV  DS,AX
        MOV  SI,SPOfs
        MOV  DI,DPOfs
@1:
        LODSW
        SHR  AX,1
        SHR  AX,1
        STOSB
        MOV  AL,AH
        STOSB
        LODSW
        SHR  AX,1
        SHR  AX,1
        STOSB
        LOOP @1
        POP  DS
      END;
      Count := Limit - Data_Start;
      IF Count > 32000 THEN
        Count := 32000;
      SPOfs := Limit;
      DPOfs := Ofs(VBuf1^);
      DPSeg := Seg(VBuf1^) + (DPOfs SHR 4);
      DPOfs := DPOfs AND $000F;
      ASM
        PUSH DS
        MOV  CX,Count
        MOV  AX,DPSeg
        MOV  ES,AX
        MOV  AX,SPSeg
        MOV  DS,AX
        MOV  SI,SPOfs
        MOV  DI,DPOfs
@2:
        DEC  SI
        MOV  AL,[SI]
        MOV  AH,AL
        AND  AL,$0F
        STOSB
        MOV  AL,AH
        SHR  AL,1
        SHR  AL,1
        SHR  AL,1
        SHR  AL,1
        AND  AL,0FH
        STOSB
        LOOP @2
        POP  DS
      END;
    END;
    Delay(1000);
  END;

BEGIN
  IF OpenOK(1,'.BMP') THEN BEGIN
    ReadData;
    Close(S1);
  END;
END;  { Load_BMP_Data }

PROCEDURE Save_BMP_Data;
BEGIN
END;  { Save_BMP_Data }

END.
